/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.speech;

import com.baidu.aip.speech.AipSpeech;
import com.baidu.aip.speech.TtsResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PromptSoundSpeech
extends AipSpeech {
    private Map<Integer, AudioConfig> audioConfigs;

    public PromptSoundSpeech(String appId, String apiKey, String secretKey, String configPath) {
        super(appId, apiKey, secretKey);
        this.initializeConfig(configPath);
    }

    private void initializeConfig(String configPath) throws IllegalArgumentException, RuntimeException {
        try {
            String jsonContent;
            HashMap<Integer, AudioConfig> newConfig = new HashMap<Integer, AudioConfig>();
            if (this.isJsonArray(configPath)) {
                jsonContent = configPath;
            } else if (configPath.startsWith("http://") || configPath.startsWith("https://")) {
                jsonContent = new String(this.downloadFromUrl(configPath));
            } else {
                File configFile = new File(configPath);
                if (!configFile.exists()) {
                    throw new IllegalArgumentException("config file not exist: " + configPath);
                }
                jsonContent = new String(Files.readAllBytes(configFile.toPath()), StandardCharsets.UTF_8);
            }
            JSONArray jsonArray = new JSONArray(jsonContent);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                if (!obj.has("audioType") || !obj.has("audioPath")) {
                    throw new IllegalArgumentException("config file item not exist");
                }
                int audioType = obj.getInt("audioType");
                String audioPath = obj.getString("audioPath");
                byte[] audioData = this.loadAudioData(audioPath);
                String audioFormat = this.getAudioFormat(audioPath);
                newConfig.put(audioType, new AudioConfig(audioType, audioPath, audioData, audioFormat));
            }
            if (this.audioConfigs != null) {
                this.audioConfigs.values().forEach(AudioConfig::clearAudioData);
            }
            this.audioConfigs = newConfig;
        }
        catch (IOException | JSONException e) {
            throw new RuntimeException("init config failed: " + e.getMessage(), e);
        }
    }

    public List<TtsResponse> synthesis(String text, String lang, int ctp, List<Integer> audioTypes, HashMap<String, Object> options) {
        TtsResponse rawSynthesisResult = super.synthesis(text, lang, ctp, options);
        if (rawSynthesisResult == null || rawSynthesisResult.getData() == null) {
            return Collections.singletonList(rawSynthesisResult);
        }
        try {
            return this.mergeAudios(rawSynthesisResult, audioTypes);
        }
        catch (FFmpegFrameRecorder.Exception e) {
            LOGGER.error("merge prompt sound error occurred, skip merge: ", (Throwable)e);
            return Collections.singletonList(rawSynthesisResult);
        }
    }

    private byte[] loadAudioData(String path) throws IOException {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            return this.downloadFromUrl(path);
        }
        File audioFile = new File(path);
        if (!audioFile.exists()) {
            throw new IllegalArgumentException("audio file not exist: " + path);
        }
        return Files.readAllBytes(audioFile.toPath());
    }

    private boolean isJsonArray(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            new JSONArray(str);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private byte[] downloadFromUrl(String urlString) throws IOException {
        URL url = new URL(urlString);
        try (InputStream is = url.openStream();){
            int bytesRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[8192];
            while ((bytesRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, bytesRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
    }

    private String getAudioFormat(String audioPath) {
        int dotIndex;
        if (audioPath == null || audioPath.isEmpty()) {
            return "mp3";
        }
        String path = audioPath;
        int queryIndex = path.indexOf(63);
        if (queryIndex != -1) {
            path = path.substring(0, queryIndex);
        }
        if ((dotIndex = path.lastIndexOf(46)) != -1 && dotIndex < path.length() - 1) {
            return path.substring(dotIndex + 1).toLowerCase();
        }
        return "mp3";
    }

    private List<TtsResponse> mergeAudios(TtsResponse originalResponse, List<Integer> audioTypes) throws FFmpegFrameRecorder.Exception {
        ArrayList<TtsResponse> mergedResponses = new ArrayList<TtsResponse>();
        for (int audioType : audioTypes) {
            byte[] resultAudio = originalResponse.getData();
            if (this.audioConfigs.containsKey(audioType)) {
                resultAudio = this.doMergeAudio(originalResponse.getData(), this.audioConfigs.get(audioType).getAudioData(), this.audioConfigs.get(audioType).getAudioFormat());
            }
            TtsResponse mergedResponse = new TtsResponse();
            mergedResponse.setData(resultAudio);
            mergedResponses.add(mergedResponse);
        }
        return mergedResponses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] doMergeAudio(byte[] originAudio, byte[] soundAudio, String soundFormat) throws FFmpegFrameRecorder.Exception {
        byte[] byArray;
        FFmpegFrameGrabber originGrabber = null;
        FFmpegFrameGrabber soundGrabber = null;
        FFmpegFrameRecorder recorder = null;
        ByteArrayOutputStream outputStream = null;
        try {
            Frame frame;
            originGrabber = new FFmpegFrameGrabber((InputStream)new ByteArrayInputStream(originAudio));
            originGrabber.start();
            soundGrabber = new FFmpegFrameGrabber((InputStream)new ByteArrayInputStream(soundAudio));
            soundGrabber.start();
            int channels = Math.max(originGrabber.getAudioChannels(), soundGrabber.getAudioChannels());
            int sampleRate = Math.max(originGrabber.getSampleRate(), soundGrabber.getSampleRate());
            outputStream = new ByteArrayOutputStream();
            recorder = new FFmpegFrameRecorder((OutputStream)outputStream, 2);
            switch (soundFormat.toLowerCase()) {
                case "mp3": {
                    recorder.setAudioCodec(86017);
                    break;
                }
                case "wav": {
                    recorder.setAudioCodec(65536);
                    break;
                }
                case "aac": {
                    recorder.setAudioCodec(86018);
                    break;
                }
                case "flac": {
                    recorder.setAudioCodec(86028);
                    break;
                }
                default: {
                    recorder.setAudioCodec(86017);
                }
            }
            recorder.setFormat(soundFormat.toLowerCase());
            recorder.setAudioChannels(channels);
            recorder.setSampleRate(sampleRate);
            recorder.setAudioBitrate(64000);
            recorder.start();
            while ((frame = soundGrabber.grabSamples()) != null) {
                if (frame.samples == null) continue;
                recorder.recordSamples(frame.sampleRate, frame.audioChannels, frame.samples);
            }
            while ((frame = originGrabber.grabSamples()) != null) {
                if (frame.samples == null) continue;
                recorder.recordSamples(frame.sampleRate, frame.audioChannels, frame.samples);
            }
            byArray = outputStream.toByteArray();
            this.closeResource((AutoCloseable)recorder);
            this.closeResource((AutoCloseable)originGrabber);
            this.closeResource((AutoCloseable)soundGrabber);
            if (outputStream == null) return byArray;
        }
        catch (FFmpegFrameGrabber.Exception e) {
            e.printStackTrace();
            byte[] byArray2 = null;
            return byArray2;
        }
        try {
            outputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byArray;
        finally {
            this.closeResource((AutoCloseable)recorder);
            this.closeResource((AutoCloseable)originGrabber);
            this.closeResource((AutoCloseable)soundGrabber);
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void closeResource(AutoCloseable resource) {
        block9: {
            if (resource != null) {
                try {
                    if (resource instanceof FFmpegFrameGrabber) {
                        FFmpegFrameGrabber grabber = (FFmpegFrameGrabber)resource;
                        try {
                            grabber.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        grabber.close();
                        grabber.release();
                        break block9;
                    }
                    if (resource instanceof FFmpegFrameRecorder) {
                        FFmpegFrameRecorder recorder = (FFmpegFrameRecorder)resource;
                        try {
                            recorder.stop();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        recorder.close();
                        recorder.release();
                        break block9;
                    }
                    resource.close();
                }
                catch (Exception e) {
                    LOGGER.warn("Error closing resource: {}", (Object)e.getMessage());
                }
            }
        }
    }

    public static class AudioConfig {
        private int audioType;
        private String audioPath;
        private byte[] audioData;
        private String audioFormat;

        public AudioConfig() {
        }

        public AudioConfig(int audioType, String audioPath, byte[] audioData, String audioFormat) {
            this.audioType = audioType;
            this.audioPath = audioPath;
            this.audioData = audioData;
            this.audioFormat = audioFormat;
        }

        public int getAudioType() {
            return this.audioType;
        }

        public String getAudioPath() {
            return this.audioPath;
        }

        public byte[] getAudioData() {
            return this.audioData;
        }

        public String getAudioFormat() {
            return this.audioFormat;
        }

        public void clearAudioData() {
            this.audioData = null;
        }
    }
}

