/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.speech;

import com.baidu.aip.speech.BaiduWebSocketListener;
import java.net.URI;
import java.nio.ByteBuffer;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

class BaiduWebSocketClient
extends WebSocketClient {
    private BaiduWebSocketListener listener;

    public BaiduWebSocketClient(URI serverUri, BaiduWebSocketListener listener) {
        super(serverUri);
        this.listener = listener;
    }

    public void onOpen(ServerHandshake handshake) {
        if (this.listener != null) {
            this.listener.onOpen();
        }
    }

    public void onMessage(String message) {
        if (this.listener != null) {
            this.listener.onMessage(message);
        }
    }

    public void onMessage(ByteBuffer bytes) {
        if (this.listener != null) {
            this.listener.onMessage(bytes.array());
        }
    }

    public void onClose(int code, String reason, boolean remote) {
        if (this.listener != null) {
            this.listener.onClose(code, reason, remote);
        }
    }

    public void onError(Exception ex) {
        if (this.listener != null) {
            this.listener.onError(ex);
        }
    }
}

